implementation module AppleEventDevice;

import StdClass,StdBool,StdArray,StdInt,StdString,StdChar;
import ioState;
import files;

import code from "cae.obj";

AppleEventFunctions :: DeviceFunctions *s;
AppleEventFunctions
	= (DummyAppleEventFunction,OpenAppleEventDevice,IOAppleEventDevice,CloseAppleEventDevice,DummyAppleEventFunction);

DummyAppleEventFunction :: !(IOState s) -> IOState s;
DummyAppleEventFunction ioState = ioState;

OpenAppleEventDevice :: !(DeviceSystem s (IOState s)) !(IOState s) -> IOState s;
OpenAppleEventDevice (AppleEventSystem apple_event_system_state) io_state
	| install_apple_event_handlers==0
		= IOStateSetDevice io_state (AppleEventSystemState apple_event_system_state);
	=	io_state;

CloseAppleEventDevice :: !(IOState s) -> IOState s;
CloseAppleEventDevice io_state = IOStateRemoveDevice io_state AppleEventDevice;

IOAppleEventDevice	:: !Event !*s !(IOState *s) -> (!Bool,!*s,!IOState *s);
IOAppleEventDevice (b,what,message,when,p1,p2,modifiers) s0 io_state0
// RWS ...
	| what == OsEvent
		&& message >> 24 == SuspendResumeMessage
			 && (message bitand ResumeFlag) <> 0
			 && (message bitand ConvertClipboardFlag) <> 0
			# (programState, ioState)
					=	handlers.clipboardChangedHandler s0 io_state1;
			=	(True, programState, ioState)
// ... RWS
	| what==HighLevelEvent
// RWS ...
		| r==4 && (result_string % (0,3) == "QUIT")
			# (programState, ioState)
				=	handlers.quitHandler s0 io_state1
			=	(True, programState, ioState);
		| r >= 6 && (result_string % (0, 5) == "SCRIPT")
			# (programState, ioState)
				=	handlers.scriptHandler (result_string % (6,r-1)) s0 io_state1
			=	(True, programState, ioState)
// ... RWS
		= if (r>4)
			(True,s1,io_state2)
			(False,s0,io_state0);
	=	(False, s0, io_state0);
	{}{
		(s1,io_state2) = open_files 4 s0 io_state1;
		(AppleEventSystemState handlers,io_state1) = IOStateGetDevice io_state0 AppleEventDevice;

		r=handle_apple_event what message when p1 p2 modifiers result_string;
			
		result_string=createArray 2048 ' ';
		open_files i s0 io_state0
			| i>=r
				= (s0,io_state0);
				= open_files (i+70) s1 io_state1;
			{
				(s1,io_state1)= handlers.openHandler file_name s0 io_state0;

				(file_name,_)=Get_directory_path vrefnum parid name NewToolbox;
		
				vrefnum = (toInt (result_string.[i])<<8) bitor (toInt (result_string.[i+1]));
				parid =	(toInt (result_string.[i+2])<<24) bitor (toInt (result_string.[i+3])<<16) bitor
						(toInt (result_string.[i+4])<<8) bitor (toInt (result_string.[i+5]));
				length=toInt(result_string .[i+6]);
				name=result_string % (i+7,i+6+length);
			}
	}

install_apple_event_handlers :: Int;
install_apple_event_handlers
	= code ()(r=D0){
		call	.install_apple_event_handlers
	}

handle_apple_event :: !Int !Int !Int !Int !Int !Int !String -> Int;
handle_apple_event what message when p1 p2 modifiers string
	= code (modifiers=W,p1=W,p2=W,when=L,message=L,what=W,string=O0D0U)(r=I16D0){
		instruction 0x38970000	|	addi	r4,r23,0
	 	call	.handle_apple_event
 	}

/* also defined in deltaFileSelect: */

String64 :: String;
String64 = createArray 64 '@';

Get_name_and_parent_id_of_directory :: !Int !Int !*Toolbox -> (!String,!Int,!*Toolbox);
Get_name_and_parent_id_of_directory volumeNumber directoryId tb
	| osError==0
		= (folderName,parentId,tb1);
	where {
		(osError,folderName,parentId,tb1) = GetCatInfo2 volumeNumber directoryId String64 tb;
	};

Get_directory_path :: !Int !Int !String !*Toolbox -> (!String, !*Toolbox);
Get_directory_path volumeNumber directoryId path tb
	| directoryId==2
		= (folderName +++ ":" +++ path, tb1);
		= Get_directory_path volumeNumber parentId (folderName +++ ":" +++ path) tb1;
	where {
		(folderName, parentId, tb1) = Get_name_and_parent_id_of_directory volumeNumber directoryId tb;
	};
/* */
